/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackSettingsManager;

public class SyncPlayerSettingsMessage {
    @Nullable
    private final CompoundNBT settingsNbt;

    public SyncPlayerSettingsMessage(@Nullable CompoundNBT settingsNbt) {
        this.settingsNbt = settingsNbt;
    }

    public static void encode(SyncPlayerSettingsMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.func_150786_a(msg.settingsNbt);
    }

    public static SyncPlayerSettingsMessage decode(PacketBuffer packetBuffer) {
        return new SyncPlayerSettingsMessage(packetBuffer.func_150793_b());
    }

    static void onMessage(SyncPlayerSettingsMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncPlayerSettingsMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncPlayerSettingsMessage msg) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || msg.settingsNbt == null) {
            return;
        }
        BiConsumer<PlayerEntity, CompoundNBT> setSettings = BackpackSettingsManager::setPlayerBackpackSettingsTag;
        setSettings.accept((PlayerEntity)player, msg.settingsNbt);
    }
}

